#!/bin/bash

function Main
{
 if [ -x $(command -v "dbus-send" >/dev/null 2>&1) ] ; then 

  StartConsoleKit  

  TVD_CTR=0
  TVD_WAIT=1
  while [ $TVD_CTR -lt 10 -a "$TVD_WAIT" != 0 ] ; do

    CheckNetwork && CheckConsoleKit
    TVD_WAIT=$?

    if [ $TVD_WAIT != 0 ]; then
      echo -n .
      TVD_CTR=$(($TVD_CTR + 1))
      sleep 1
    fi
  done
 fi
}

function CheckNetwork
{
  # check network (interface is up, not only MAC)
  #  ip -4 link | grep 'link/' | grep -qv '00:00:00:00:00:00' || TVD_RESPONSE=''
  ip -4 addr | grep 'inet' | grep -qv 'inet 127.'
}

function CheckConsoleKit
{
  dbus-send --print-reply --system --dest=org.freedesktop.DBus / org.freedesktop.DBus.NameHasOwner string:org.freedesktop.ConsoleKit | grep -q true
}

function StartConsoleKit
{
  dbus-send --system --print-reply --dest=org.freedesktop.DBus / org.freedesktop.DBus.StartServiceByName string:org.freedesktop.ConsoleKit uint32:0
}

Main

exit 0
