#ifndef DRV_UTILS_H
#define DRV_UTILS_H

#include "offsets.h"

//i/o write/read wrapper prototypes
int drv_write_byte (int fd, unsigned char data, short address);
int drv_write_word (int fd, short data, short address);
unsigned char drv_read_byte (int fd, short address);
unsigned short drv_read_word (int fd, short address);

//board functions
int init_board (int fd);
int open_board (void);
void close_board (int fd);

void output_dac (int gFD, int channel, double voltage);
double input_adc (int fd, int channel);

double output_encoder (int fd, int chan, short val);
double input_encoder (int fd, int chan);

void config_dio (int fd, int dirA, int dirB, int dirC0, 
                 int dirC1, int dirD0, int dirD1);
void write_dio (int fd, int channel, unsigned char value);
unsigned char read_dio (int fd, int channel);

//defines for board addressing and initialization
// borrowed frm robotstg.h
#define ENC_COUNT_BASE          0x0000
#define ENC_LOAD_BASE           0x0000
#define ENC_CTRL_BASE			      0x0002
#define ENC_MCR_INIT            0x2323
#define ENC_MCR_RESET           0x0505
#define ENC_ICR_INIT            0x6868
#define ENC_OCR_INIT            0x8080
#define ENC_MCR_READ            0x0303
#define ENC_MCR_LOAD            0x0808
#define ENC_QCR_INIT			      0xC3C3

#endif
