# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..5\n"; }
END {print "not ok 1\n" unless $loaded;}
use I2A2::libpuidX;
$loaded = 1;
print "ok 1\n";

open P, "<test.pem" or die "Can't open test certificate (test.pem)";
undef $/;	# so the entire file is read
$pem = <P>;
close P;

if (I2A2::libpuidX::X509fromPEM($pem, $x509)) {
	print "not ok 2\n";
	print "not ok 3\n";
	print "not ok 4\n";
	print "not ok 5\n";
} else {
	print "ok 2\n";
	$err = I2A2::libpuidX::puid_getcertPUID($x509, $puid)
		|| $puid != 10226466;
	print $err ? "not ok 3\n" : "ok 3\n";
	$err = I2A2::libpuidX::puid_getcertserial($x509, $buf)
		|| $buf ne "E0B720A934";
	print $err ? "not ok 4\n" : "ok 4\n";
	$err = I2A2::libpuidX::puidnetd_strerror(17) ne 'DBM returned an error';
	print $err ? "not ok 5\n" : "ok 5\n";
}


######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

