#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

#include "puid_types.h"
#include "puidnetd.h"
#define	OPENSSL_ALGORITHM_DEFINES
#include "openssl/opensslconf.h"
#include "openssl/x509.h"
#include "extlib/extlib.h"

static int
not_here(s)
char *s;
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

static double
constant(name, arg)
char *name;
int arg;
{
    errno = 0;
    switch (*name) {
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}


MODULE = I2A2::libpuidX		PACKAGE = I2A2::libpuidX	PREFIX = I2A2_

PROTOTYPES: ENABLE

double
constant(name,arg)
	char *		name
	int		arg

int
I2A2_X509fromPEM(pem, x509)
	const char *	pem
	X509 *		&x509
	OUTPUT:
	RETVAL
	x509

int
puid_getcertPUID(x509, PUID)
	X509 *		x509
	puid_t 		&PUID
	OUTPUT:
	RETVAL
	PUID

int
puid_puissuer(x509)
	X509 *		x509
	OUTPUT:
	RETVAL

int
puid_getcertserial(x, buf)
	X509 *		x
	char *		buf = NO_INIT
	PREINIT:
	char	buffer[30];
	int	bufl = 30;
	CODE:
		RETVAL = puid_getcertserial(x, buffer, bufl);
	OUTPUT:
	buf	if (RETVAL == 0) sv_setpv(ST(1), buffer);
	RETVAL

char *
puidnetd_strerror(e)
	int	e
	OUTPUT:
	RETVAL

