#include <stdio.h>
#include <puid_types.h>
#define	OPENSSL_ALGORITHM_DEFINES
#include <openssl/opensslconf.h>
#include <openssl/bio.h>
#include <openssl/pem.h>
#include <openssl/x509.h>
#include <puid_x509ext.h>


int 
I2A2_X509fromPEM(pem, px509)
const char	*pem;
X509		 **px509;
{
	BIO *pbio;
	X509 *x509;

	/* create a BIO buffer and write the PEM certificate to it */
	pbio = BIO_new(BIO_s_mem());
	BIO_write(pbio, pem, strlen(pem)+1);

	/* parse the certificate from the BIO buffer and free the buffer */
	x509 = PEM_read_bio_X509(pbio, NULL, NULL, NULL);
	BIO_free(pbio);

	if (x509) {
		*px509 = x509;
		return 0;
	} else {
		return 1;
	}
}
