use ExtUtils::MakeMaker;
$Verbose = 1;
$OPENSSL_DIR = $ENV{OPENSSL_DIR};
if (!defined $OPENSSL_DIR) {
    print "Enter the location of the OpenSSL installation: ";
    $OPENSSL_DIR = <>;
    chomp $OPENSSL_DIR;
    $ENV{OPENSSL_DIR} = $OPENSSL_DIR;
}
WriteMakefile(
    NAME	=> 'I2A2::extlib',
    INC		=> "-I$OPENSSL_DIR/include -IlibpuidX/include",
    clean	=> {'FILES' => 'libpuidX libextlib$(LIB_EXT)'},
# You'll probably need to edit LIBPUIDX_CCOPTS for your system
    macro	=> {'LIBPUIDX_CCOPTS' => '-g -xarch=v8',
		    'LIBPUIDX' => 'libpuidX/lib/libpuidX$(LIB_EXT)',
		    'OPENSSL_DIR' => "$OPENSSL_DIR",
		   },
);

sub MY::top_targets {
	'
pure_all:

all:	$(LIBPUIDX) libextlib$(LIB_EXT)

libextlib$(LIB_EXT): $(O_FILES) $(LIBPUIDX)
	rm -f $@
	$(CP) $(LIBPUIDX) $@
	$(AR) cr $@ $(O_FILES)
	$(RANLIB) $@

$(LIBPUIDX): libpuidX/lib
	( cd libpuidX/lib;	\
	  $(MAKE) DEBUG="$(LIBPUIDX_CCOPTS)" LIB=libpuidX$(LIB_EXT)	\
	      OpenSSL_root=$(OPENSSL_DIR)	\
	)

libpuidX/include libpuidX/lib: ../libpuidX.tar.gz
	gunzip < ../libpuidX.tar.gz | tar xvf -
	touch libpuidX/include libpuidX/lib

';
}
