use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
$OPENSSL_DIR = $ENV{OPENSSL_DIR};
if (!defined $OPENSSL_DIR) {
    print "Enter the location of the OpenSSL installation: ";
    $OPENSSL_DIR = <>;
    chomp $OPENSSL_DIR;
    $ENV{OPENSSL_DIR} = $OPENSSL_DIR;
}
WriteMakefile(
    'NAME'	=> 'I2A2::libpuidX',
    'VERSION_FROM' => 'libpuidX.pm', # finds $VERSION
    'DEFINE'	=> '',     # e.g., '-DHAVE_SOMETHING' 
    'INC'	=> '$(SSLHDR) -Iextlib/libpuidX/include',
    'LIBS' => "-L$OPENSSL_DIR/lib -lssl -lcrypto",
    'DIR'	=> ['extlib'],
    'MYEXTLIB'	=> 'extlib/libextlib$(LIB_EXT)',
    'PM'	=> {'puidnetd.ph' => '$(INST_LIB)/I2A2/puidnetd.ph',
		    'libpuidX.pm' => '$(INST_LIB)/I2A2/libpuidX.pm'},
    clean	=> {'FILES' => 'puidnetd.ph'},
    macro	=> {'SSLHDR' => "-I$OPENSSL_DIR/include"},
);


sub MY::postamble {
q[
puidnetd.ph:	extlib/libpuidX/include/puidnetd.h
	sed -e "/#include/d" -e "s/'/\"/g" extlib/libpuidX/include/puidnetd.h | h2ph > puidnetd.ph

$(MYEXTLIB):	extlib/Makefile
	cd extlib && $(MAKE)

extlib/libpuidX/include/puidnetd.h:
	cd extlib && $(MAKE)

];
}
