package I2A2::Access;
# File: I2A2/Access/Makefile.PL

BEGIN {
    $APACHE_DIR = $ENV{APACHE_DIR};
    if (!defined $APACHE_DIR) {
	print "Enter location of installed Apache directory: ";
	$APACHE_DIR = <STDIN>;
	chomp $APACHE_DIR;
	$ENV{APACHE_DIR} = $APACHE_DIR;
    }
    $ENV{PERL_MAKEFILE_PL} = 1;
}

use lib "$APACHE_DIR/lib/perl";
use ExtUtils::MakeMaker;

use Apache::ExtUtils qw(command_table);
use Apache::src ();

# build the test.pl file
eval `cat test.pl.tmpl`;
die "$@" if $@;

my @directives = (
	{  name		=> 'DefaultRealm',
	   errmsg	=> 'The list of realms to be accepted.',
	   args_how	=> 'TAKE1',
	   req_override	=> 'OR_AUTHCFG',
	},
	{  name		=> 'Realms',
	   errmsg	=> 'The list of realms to be accepted.',
	   args_how	=> 'ITERATE',
	   req_override	=> 'OR_AUTHCFG',
	},
	{  name		=> 'AllowUser',
	   errmsg	=> 'A list of aliases/PUIDs to be allowed access.',
	   args_how	=> 'ITERATE',
	   req_override	=> 'OR_AUTHCFG',
	},
	{  name		=> 'DenyUser',
	   errmsg	=> 'A list of aliases/PUIDs to be denied access.',
	   args_how	=> 'ITERATE',
	   req_override	=> 'OR_AUTHCFG',
	},
	{  name		=> 'CharsExp',
	   errmsg	=> 'A characteristic expression that the user must meet to be granted access.',
	   args_how	=> 'RAW_ARGS',
	   req_override	=> 'OR_AUTHCFG',
	},
    );

command_table(\@directives);

WriteMakefile(
    'NAME'	=> __PACKAGE__,
    'VERSION_FROM' => 'Access.pm', # finds $VERSION
    'LIBS'	=> [''],   # e.g., '-lm' 
    'DEFINE'	=> '',     # e.g., '-DHAVE_SOMETHING' 
    'INC'	=> Apache::src->new->inc,
    'clean'	=> {'FILES' => 'test.pl'},
);
__END__
